/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.security;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;

public class VWTypeAheadPanel
extends JPanel
implements DocumentListener,
KeyListener {
    public static final String ACMD_UPDATE_INSERT = "UpdateInsert";
    public static final String ACMD_UPDATE_REMOVE = "UpdateRemove";
    public static final String ACMD_ENTER_KEY = "EnterKey";
    private EventListenerList m_listenerList = new EventListenerList();
    private JTextField m_typeAheadTextField = null;

    public VWTypeAheadPanel() {
        this.init();
    }

    public void addActionListener(ActionListener listener) {
        if (this.m_listenerList != null) {
            this.m_listenerList.add(ActionListener.class, listener);
        }
    }

    public void removeActionListener(ActionListener listener) {
        if (this.m_listenerList != null) {
            this.m_listenerList.remove(ActionListener.class, listener);
        }
    }

    public String getFilterString() {
        if (this.m_typeAheadTextField == null) {
            return null;
        }
        return this.m_typeAheadTextField.getText();
    }

    public void resetFilterString() {
        if (this.m_typeAheadTextField != null) {
            this.m_typeAheadTextField.setText("");
            this.m_typeAheadTextField.requestFocus();
        }
    }

    public void removeReferences() {
        if (this.m_typeAheadTextField != null) {
            this.m_typeAheadTextField.getDocument().removeDocumentListener(this);
            this.m_typeAheadTextField.removeKeyListener(this);
            this.m_typeAheadTextField = null;
        }
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void insertUpdate(DocumentEvent event) {
        if (event.getDocument() == this.m_typeAheadTextField.getDocument()) {
            this.fireActionEvent(ACMD_UPDATE_INSERT);
        }
    }

    public void removeUpdate(DocumentEvent event) {
        if (event.getDocument() == this.m_typeAheadTextField.getDocument()) {
            this.fireActionEvent(ACMD_UPDATE_REMOVE);
        }
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
        if (event.getKeyCode() == 10) {
            this.fireActionEvent(ACMD_ENTER_KEY);
            this.m_typeAheadTextField.selectAll();
        }
    }

    public void keyTyped(KeyEvent event) {
    }

    private void init() {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(0, 0, 0, 0);
            this.m_typeAheadTextField = new JTextField();
            this.m_typeAheadTextField.setName("m_typeAheadTextField_VWTypeAheadPanel");
            this.m_typeAheadTextField.getDocument().addDocumentListener(this);
            this.m_typeAheadTextField.addKeyListener(this);
            this.add((Component)this.m_typeAheadTextField, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_typeAheadTextField, this, VWResource.s_typeAheadNameTextField, VWResource.s_typeAheadNameTextField);
            this.m_typeAheadTextField.addKeyListener(VWKeyAdapter.s_keyAdapter);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void fireActionEvent(String actionCommand) {
        ActionEvent event = new ActionEvent(this, 1001, actionCommand);
        if (event == null) {
            return;
        }
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }
}

